IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Contrato_Cli_Edad') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Contrato_Cli_Edad
END
GO

CREATE FUNCTION [dbo].[CF_Contrato_Cli_Edad](@pFecha_Nac DATETIME, @pFlag_Valida_Edad_Escolar SMALLINT, @Edad_Min SMALLINT, @Edad_Max SMALLINT)
RETURNS SMALLINT 
AS

BEGIN
DECLARE @Edad					SMALLINT
DECLARE @Respuesta				SMALLINT
DECLARE @Mes					SMALLINT
DECLARE @Dia					SMALLINT

SET @Edad = (SELECT (CAST(DATEDIFF(dd, @pFecha_Nac, (GETDATE() + 1)) / 365.25 AS SMALLINT)))
SET @Mes = 	(SELECT MONTH(@pFecha_Nac))

IF (@pFlag_Valida_Edad_Escolar = 1)
BEGIN
	IF (@Mes > 6)  
	BEGIN
		SET @Respuesta = @Edad
		RETURN @Respuesta
	END

	IF (@Edad = @Edad_Max AND @Mes < 7)  
	BEGIN
		SET @Respuesta = @Edad + 1
		RETURN @Respuesta
	END

	IF (@Edad + 1 = @Edad_Min AND @Mes < 7)  
	BEGIN
		SET @Respuesta = @Edad + 1
		RETURN @Respuesta
	END

	SET @Respuesta = @Edad
END
ELSE
	SET @Respuesta = @Edad


RETURN ISNULL(@Respuesta, 0)
END

--SELECT DBO.CF_Contrato_Cli_Edad ('20170101',0,4,5)
--SELECT DBO.CF_Contrato_Cli_Edad ('20180501',1,4,5)